import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { mutationResponse } from "../../../util/processResponse.js";

const initialState = {
    newRefundMessage: {},
    loading: false,
};

export const postRefundMessage = createAsyncThunk(
    "user/postNewRefund",
    async (obj) => {
        try {
            const { access_token, urlPost, method, formData } = obj;
            const data = await mutationResponse(
                urlPost,
                method,
                formData,
                access_token
            );
            return data;
        } catch (err) {
            return;
        }
    }
);

const postRefundMessageSlice = createSlice({
    name: "user",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(postRefundMessage.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(postRefundMessage.fulfilled, (state, { payload }) => {
            state.newRefundMessage = payload;
            state.loading = false;
        });
        builder.addCase(postRefundMessage.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default postRefundMessageSlice.reducer;
